<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registered Travel Agent</title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            border: 1px solid black;
        }

        th,
        td {
            border: 1px solid black;
            padding: 8px;
            text-align: left;
        }

        th {
            background-color: #f2f2f2;
        }

        .hotel-column {
            max-width: 200px;
            word-wrap: break-word;
        }
    </style>
</head>

<body>
    @php
        $tour = \App\Models\TourBooking::where('id', $id)->first();
        $client = \App\Models\Client::where('id', $tour->clientid)->first();
        $new = \App\Models\HotelBooking::where('tourb_id', $id)->get();
    @endphp

    @if ($tour && $client)
        <div>
            <table
                style="border-style: double; border-width: 8px; border-color: black; font-family: Verdana, Arial, Helvetica, sans-serif; color: rgb(0, 0, 0);"
                width="100%">
                <tbody>
                    <tr>
                        <td
                            style="font-family: Verdana, Arial, Helvetica, sans-serif; padding: 7px; vertical-align: top;">
                            <p style="font-family: Verdana, Arial, Helvetica, sans-serif;">
                                <span style="font-size: 24px; line-height: 26px; color: rgb(0, 0, 0);">LANKA
                                    GETAWAYS</span>
                            </p>
                        </td>
                        <td style="font-family: Verdana, Arial, Helvetica, sans-serif; text-align: right; padding: 7px;">
                            <p style="font-family: Verdana, Arial, Helvetica, sans-serif;">
                                <span style="font-size: 24px; line-height: 26px; color: rgb(0, 0, 0);">No. 86, Station
                                    Road,</span><br>
                                <span
                                    style="font-size: 13px; line-height: 18px; color: rgb(0, 0, 0);">Palangathure,</span><br>
                                <span style="font-size: 13px; line-height: 18px; color: rgb(0, 0, 0);">Kochchikade, Sri
                                    Lanka, 11540</span><br>
                                <span style="font-size: 13px; line-height: 18px; color: rgb(0, 0, 0);"><a
                                        href="mailto:info@lankagetaways.com" style="color: rgb(0, 0, 0);"
                                        target="_blank">info@lankagetaways.com</a></span><br>
                                <span style="font-size: 13px; line-height: 18px; color: rgb(0, 0, 0);">Phone: +94 77 386
                                    6402</span>
                            </p>
                        </td>
                    </tr>
                </tbody>
            </table>
            <p
                style="font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 13px; padding: 0.4em 0 0.4em; color: rgb(0, 0, 0);">
                Dear {{ $client->name }},
            </p>
            <p
                style="font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 13px; padding-bottom: 0.4em; color: rgb(0, 0, 0);">
                Lankagetaways is pleased to share the itinerary for your upcoming tour. Please find the detailed
                schedule below:
            </p>

            <table>
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Destination</th>
                        <th class="hotel-column">Hotel</th>
                        <th class="hotel-column">Hotel Address</th>
                        <th class="hotel-column">Hotel Contact</th>
                        <th class="hotel-column">Special Notes</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($new as $item)
                        <tr>
                            <td>{{ $item->date }}</td>
                            <td>{{ $item->h_place }}</td>
                            <td class="hotel-column">{{ $item->hotel ?? 'N/A' }}</td>
                            <td class="hotel-column">{{ $item->hotel ? $item->h_address : 'N/A' }}</td>
                            <td class="hotel-column">{{ $item->hotel ? $item->h_contact : 'N/A' }}</td>
                            <td class="hotel-column">{{ $item->h_note ?? 'N/A' }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>

            <p
                style="font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 13px; padding-bottom: 0.4em; color: rgb(0, 0, 0);">
                We look forward to making your experience unforgettable. Should you have any questions or need further
                assistance, feel free to reach out.
            </p>
            <p
                style="font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 13px; margin-bottom: 0; padding-top: 15px; color: rgb(0, 0, 0);">
                Thanks & Regards,
            </p>
            <p
                style="font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 13px; margin: 0; color: rgb(0, 0, 0);">
                LANKA GETAWAYS
            </p>
        </div>
    @else
        <p>Sorry, we could not retrieve your booking information. Please contact us for further assistance.</p>
    @endif
</body>

</html>
